using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace EQTrack
{
	public partial class CustomButton : CustomRoundPanel
	{
		private Bitmap ArrowLeft = CustomPanelResources.ArrowLeft;
		private Bitmap ArrowRight = CustomPanelResources.ArrowRight;

		public CustomButton()
		{
			InitializeComponent();

			this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
			this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
		}

		private string mCaption = "";
		[
		Category("Appearance"),
		]
		public string Caption
		{
			get
			{
				return mCaption;
			}
			set
			{
				if (mCaption != value)
				{
					mCaption = value;
					this.Refresh();
				}
			}
		}

		private string mNumber = "";
		[
		Category("Appearance"),
		]
		public string Number
		{
			get
			{
				return mNumber;
			}
			set
			{
				if (mNumber != value)
				{
					mNumber = value;
					this.Refresh();
				}
			}
		}

		public enum ArrowTypes
		{
			None,
			Left,
			Right
		}
		private ArrowTypes mArrowType = ArrowTypes.Right;
		[
		Category("Appearance"),
		DefaultValue(2)
		]
		public ArrowTypes ArrowType
		{
			get
			{
				return mArrowType;
			}
			set
			{
				if (mArrowType != value)
				{
					mArrowType = value;
					this.Refresh();
				}
			}
		}

		private Font mNumberFont;
		[
		Category("Appearance"),
		]
		public Font NumberFont
		{
			get
			{
				return mNumberFont;
			}
			set
			{
				if (mNumberFont != value)
				{
					mNumberFont = value;
					this.Refresh();
				}
			}
		}

		private Color mNumberColor = SystemColors.ControlText;
		[
		Category("Appearance"),
		]
		public Color NumberColor
		{
			get
			{
				return mNumberColor;
			}
			set
			{
				if (mNumberColor != value)
				{
					mNumberColor = value;
					this.Refresh();
				}
			}
		}

		protected override void OnPaint(PaintEventArgs pevent)
		{
			base.OnPaint(pevent);

			if (mArrowType == ArrowTypes.Right)
				pevent.Graphics.DrawImage(ArrowRight, new Rectangle(this.Width - ButtonRight.Width - (this.Height / 6) - 5, ((this.Height * 2 / 3) - (ButtonBottom.Height - ButtonTop.Height)) / 2, this.Height / 6, this.Height / 3), new Rectangle(new Point(0, 0), ArrowRight.Size), GraphicsUnit.Pixel);
			else if (mArrowType == ArrowTypes.Left)
				pevent.Graphics.DrawImage(ArrowLeft, new Rectangle(ButtonLeft.Width + 5, ((this.Height * 2 / 3) - (ButtonBottom.Height - ButtonTop.Height)) / 2, this.Height / 6, this.Height / 3), new Rectangle(new Point(0, 0), ArrowLeft.Size), GraphicsUnit.Pixel);

			StringFormat ThisStringFormat = StringFormat.GenericTypographic;
			ThisStringFormat.Alignment = StringAlignment.Near;
			if (mCaption != "")
			{
				Size SmallFontSize = pevent.Graphics.MeasureString(mCaption, this.Font, 0, ThisStringFormat).ToSize();
				int ThisLeft = 10;
				if (mArrowType == ArrowTypes.Left)
					ThisLeft = this.Width - ButtonRight.Width - 10 - SmallFontSize.Width;
				else if (mArrowType == ArrowTypes.None)
					ThisLeft = (this.Width - (ButtonRight.Width - ButtonLeft.Width) - SmallFontSize.Width) / 2;
				pevent.Graphics.DrawString(mCaption, this.Font, new SolidBrush(this.Enabled ? this.ForeColor : SystemColors.GrayText), ThisLeft, (this.Height - SmallFontSize.Height - ButtonBottom.Height) / 2, ThisStringFormat);
			}
			if (mNumber != "")
			{
				Size LargeFontSize = pevent.Graphics.MeasureString(mNumber.ToString(), this.NumberFont, 0, ThisStringFormat).ToSize();
				pevent.Graphics.DrawString(mNumber.ToString(), this.NumberFont, new SolidBrush(this.NumberColor), this.Width - ButtonRight.Width - (mArrowType == ArrowTypes.Right ? ArrowRight.Width : 0) - 15 - LargeFontSize.Width, (this.Height - LargeFontSize.Height - ButtonBottom.Height) / 2, ThisStringFormat);
			}
		}

		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.IContainer components = null;

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		/// <param name="disposing">true if managed resources should be disposed; otherwise, false.</param>
		protected override void Dispose(bool disposing)
		{
			if (disposing && (components != null))
			{
				components.Dispose();
			}
			base.Dispose(disposing);
		}

		#region Component Designer generated code

		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
			mNumberFont = this.Font;
		}

		#endregion
	}
}
